#include <string>
#include <iostream>
#include <algorithm>

class CharInventory {
public:   // Fields
    constexpr static size_t size = 'z' - 'a' + 1;
private:  // Fields
    int inventory[size];
public:   // Ctors
    CharInventory();
    CharInventory(const std::string&);
    CharInventory(const CharInventory&) = delete;
public:   // Operators
    int& operator [](const char&);
    CharInventory& operator =(const CharInventory&) = delete;
    const int& operator [](const char&) const;
};

int MissmatchRange(const std::string&, const std::string&);
void Untie();
std::string ClosestPalindrome(const std::string&);

int main() {
    Untie();
    std::string text;
    std::cin >> text;
    std::string palindrome = ClosestPalindrome(text);
    std::cout << MissmatchRange(text, palindrome) << std::endl;
    return 0;
}

void Untie() {
    std::ios_base::sync_with_stdio(false);
    std::cout.tie(nullptr);
    std::cerr.tie(nullptr);
    std::cin.tie(nullptr);
}
int MissmatchRange(const std::string& original, const std::string& palindrome) {
    int l = 0;
    int r = original.size() - 1;
    while (original[l] == palindrome[l] && l < r) {
        l++;
    }
    while (original[r] == palindrome[r] && l < r) {
        r--;
    }
    return r - l + 1;
}
std::string ClosestPalindrome(const std::string& string) {
    std::string palindromes[2];
    std::string text = string;
    for (int o = 0; o < 2; o++) {
        std::string palindrome;
        CharInventory composition(text);
        const size_t& n = text.size();
        for (int i = 0; i < n; i++) {
            palindrome += '0';
        }
        if (n % 2) {
            for (int c = 'a'; c <= 'z'; c++) {
                if (composition[c] % 2) {
                    palindrome[n / 2] = c;
                    composition[c]--;
                    break;
                }
            }
        }
        for (int i = 0; i < n / 2; i++) {
            if (text.at(i) == text.at(n - 1 - i)) {
                palindrome[i] = text.at(i);
                palindrome[n - 1 - i] = text.at(i);
                composition[text.at(i)] -= 2;
            }
        }
        for (int i = 0; i < n / 2; i++) {
            if (composition[text.at(i)] && palindrome[i] == '0') {
                palindrome[i] = text.at(i);
                palindrome[n - 1 - i] = text.at(i);
                composition[text.at(i)] -= 2;
            }
        }
        for (int i = n - 1; i > n / 2 - !(n % 2); i--) {
            if (composition[text.at(i)] && palindrome[i] == '0') {
                palindrome[i] = text.at(i);
                palindrome[n - i - 1] = text.at(i);
                composition[text.at(i)] -= 2;
            }
        }
        for (int i = 0, c = 'a'; i < n / 2; i++) {
            if (palindrome[i] == '0') {
                while (!composition[c] && c <= 'z') {
                    c++;
                }
                palindrome[i] = c;
                palindrome[n - 1 - i] = c;
                composition[c] -= 2;
            }
        }
        palindromes[o] = palindrome;
        std::reverse(text.begin(), text.end());
    }
    int m1 = MissmatchRange(string, palindromes[0]);
    int m2 = MissmatchRange(string, palindromes[1]);
    return m1 < m2 ? palindromes[0] : palindromes[1];
}

// CharInventory
// Constructors
CharInventory::CharInventory()
: inventory{ } {
}
CharInventory::CharInventory(const std::string& text)
: inventory{ } {
    for (const auto& ch : text) {
        (*this)[ch]++;
    }
}

// Operators
int& CharInventory::operator [](const char& ch) {
    return inventory[ch - 'a'];
}
const int& CharInventory::operator [](const char& ch) const {
    return inventory[ch - 'a'];
}